
******************************************************************
*
* Impact Funciton (using an artificial dataset)
*
* JOSEF BRDERL, LMU, February 2015
*
******************************************************************

* These are the variables in the dataset:
* id       person identifier
* time     # panel wave
* wage     monthly wage in Euro
* marrdur  duration of marriage


*************************************
** Preliminaries    *****************
*************************************
clear 
set more off

* Load data
cd  "K:\Vorlesung PDA\Stata Beispiele\Artificial Data\"    //Adapt this path!
use "Attrition Bias.dta", clear

***** Declare data to be panel data *****
xtset id time


******************************************
* Effect Heterogeneity - Impact Function Bias
******************************************
twoway  (scatter wage time, ylabel(0(500)3000, grid angle(0))                ///
                 ymtick(100(100)2900, grid) c(L))                            ///
        (scatter wage time if marrdur>0 & id==1, c(i))                          ///
        (scatter wage time if marrdur>0 & id>1,  c(L) mcolor(red) lcolor(red)), ///
		legend(row(1) pos(6) ring(0) order(1 3) label(1 "single") label(3 "married"))

xtreg wage i.marrdur, fe  
est store FE1

estimates table FE1, b(%5.0f) star stfmt(%6.0f) stats(N N_g)

******************************************
* Effect Heterogeneity - Impact Function Bias II
******************************************
gen marr = marrdur>0
replace marr=. if marrdur==.

xtreg wage i.marr, fe  
est store FE1

estimates table FE1, b(%5.0f) star stfmt(%6.0f) stats(N N_g)



